<?php
  session_start();
  //mengecek username pada session
  if( !isset($_SESSION['email']) ){
    $_SESSION['msg'] = 'anda harus login untuk mengakses halaman ini';
    header('Location: index.php');
  }
  date_default_timezone_set('Asia/Jakarta');
  include_once 'connection/connect.php';

 
  if (isset($_GET['month'])) {
      $get_month = $_GET['month'];
      switch($get_month){
      case "Januari":
        $set_month = 1;
        break;
      case "Februari":
        $set_month = 2;
        break;
      case "Maret":
        $set_month = 3;
        break;
      case "April":
        $set_month = 4;
        break;
      case "Mei":
        $set_month = 5;
        break;
      case "Juni":
        $set_month = 6;
        break;
      case "Juli":
        $set_month = 7;
        break;
      case "Agustus":
        $set_month = 8;
        break;
      case "September":
        $set_month = 9;
        break;
      case "Oktober":
        $set_month = 10;
        break;
      case "November":
        $set_month = 11;
        break;
      case "Desember":
        $set_month = 12;
        break;
      }

      $result = $mysqli->query("
         SELECT id, kuota, tanggal FROM kuota WHERE MONTH(tanggal)='$set_month' ORDER BY id DESC
      ");
  }else{
      if (isset($_GET['month'])) {
        $month = $_GET['month'];
      }else{
        $month = date('m');
      }
      $result = $mysqli->query("
         SELECT id, kuota, tanggal FROM kuota WHERE MONTH(tanggal)='$month' ORDER BY id DESC
      ");
    }
?>
<!doctype html>
<html lang="en" class="h-100">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="author" content="boons">

  <!-- Title -->
  <title>Aplikasi Antrian</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-+0n0xVW2eSR5OomGNYDnhzAbDsOXxcvSN1TPprVMTNDbiYZCxYbOOl7+AMvyTG2x" crossorigin="anonymous">
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap4.min.css">

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"
  rel="stylesheet"
/>
  <!-- Custom Style -->
  <link rel="stylesheet" href="assets/css/mdb.min.css">
  <link rel="stylesheet" href="assets/css/style.css">

  <style type="text/css">
    .badge {
      --mdb-badge-padding-x: 0.5em !important;
      --mdb-badge-padding-y: 0.5em !important;
    }


    * {
      box-sizing: border-box;
    }
    .select {
      position: relative;
      min-width: 200px;
    }
    .select svg {
      position: absolute;
      right: 12px;
      top: calc(50% - 3px);
      width: 10px;
      height: 6px;
      stroke-width: 2px;
      stroke: #9098a9;
      fill: none;
      stroke-linecap: round;
      stroke-linejoin: round;
      pointer-events: none;
    }
    .select select {
      -webkit-appearance: none;
      padding: 7px 40px 7px 12px;
      width: 100%;
      border: 1px solid #e8eaed;
      border-radius: 5px;
      background: #fff;
      box-shadow: 0 1px 3px -2px #9098a9;
      cursor: pointer;
      font-family: inherit;
      font-size: 16px;
      transition: all 150ms ease;
    }
    .select select:required:invalid {
      color: #5a667f;
    }
    .select select option {
      color: #223254;
    }
    .select select option[value=""][disabled] {
      display: none;
    }
    .select select:focus {
      outline: none;
      border-color: #07f;
      box-shadow: 0 0 0 2px rgba(0,119,255,0.2);
    }
    .select select:hover + svg {
      stroke: #07f;
    }
    .sprites {
      position: absolute;
      width: 0;
      height: 0;
      pointer-events: none;
      user-select: none;
    }

  </style>
</head>

<body class="d-flex flex-column h-100 bd_body">
  <main class="flex-shrink-0">
    <div class="container pt-4">


<!-- Navbar -->
<nav class="navbar navbar-collapse navbar-expand-lg navbar-light bg-light" style="border-radius: 20px !important;">
  <!-- Container wrapper -->
  <div class="container-fluid">
    <!-- Toggle button -->
    <button
      class="navbar-toggler"
      type="button"
      data-mdb-toggle="collapse"
      data-mdb-target="#navbarSupportedContent"
      aria-controls="navbarSupportedContent"
      aria-expanded="false"
      aria-label="Toggle navigation"
    >
      <i class="fas fa-bars"></i>
    </button>

    <!-- Collapsible wrapper -->
    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <!-- Navbar brand -->
      <a class="navbar-brand mt-2 mt-lg-0" href="#">
        <i class="fa-solid fa-bell text-danger" style="font-size: 40px;"></i>
      </a>
      <!-- Left links -->
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link" href="index.php">Dashboard Antrian</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="kuota.php">Kuota</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="logs.php">Logs</a>
        </li>
      </ul>
      <!-- Left links -->
    </div>
    <!-- Collapsible wrapper -->

    <!-- Right elements -->
    <div class="d-flex align-items-center">
      <!-- Avatar -->
      <div class="dropdown">
        <a
          class="dropdown-toggle d-flex align-items-center hidden-arrow"
          href="#"
          id="navbarDropdownMenuAvatar"
          role="button"
          data-mdb-toggle="dropdown"
          aria-expanded="false"
        >
        Admin  &nbsp;&nbsp;<i class="fa-solid fa-caret-down"></i>
        </a>
        <ul
          class="dropdown-menu dropdown-menu-end"
          aria-labelledby="navbarDropdownMenuAvatar"
        >
          <li>
            <a class="dropdown-item" href="logout.php">Logout</a>
          </li>
        </ul>
      </div>
    </div>
    <!-- Right elements -->
  </div>
  <!-- Container wrapper -->
</nav>
<!-- Navbar -->


                  <div class="modal fade" id="ModalTambah" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                      <div class="modal-content">
                        <form action="proccess/insert.php" method="post">
                        <div class="modal-header">
                          <h5 class="modal-title" id="exampleModalLabel">Tambah Kuota</h5>
                          <button type="button" class="btn-close" data-mdb-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                          <div class="input-group mb-3">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-circle-info"></i></span>
                            <input
                              name="kuota" id="kuota"
                              type="text"
                              class="form-control"
                              placeholder="kuota"
                              aria-label="kuota"
                              aria-describedby="basic-addon1"
                            />
                          </div>
                          <div class="input-group mb-3">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-calendar-days"></i></span>
                            <input
                              name="tanggal" id="tanggal"
                              type="date"
                              class="form-control"
                              placeholder="tanggal"
                              aria-label="tanggal"
                              aria-describedby="basic-addon1"
                            />
                          </div>
                        </div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-secondary" data-mdb-dismiss="modal">Batal</button>
                          <button type="submit" name="btn_tambah" class="btn btn-primary">Simpan</button>
                        </div>
                      </form>
                      </div>
                    </div>
                  </div>




      <div class="card border-0 shadow-sm" style="margin-top:20px;">
        <div class="card-body p-4">
          <div class="table-responsive">

            <button type="button" class="btn btn-primary" data-mdb-toggle="modal" data-mdb-target="#ModalTambah" style="margin-bottom: 20px;float: right;"><i class="fa-solid fa-plus"></i> 
            &nbsp;&nbsp;Tambah Kuota
            </button>

          <div class="input-group col-md-12" style="margin-bottom:20px">
                <form action="" method="GET">
                <label class="select" for="slct">
                  <select id="month" name="month" id="month" required="required">
                    <option value="" disabled="disabled" selected="selected">Fiter Bulan</option>
                    <option value="Januari">Januari</option>
                    <option value="Februari">Februari</option>
                    <option value="Maret">Maret</option>
                    <option value="April">April</option>
                    <option value="Mei">Mei</option>
                    <option value="Juni">Juni</option>
                    <option value="Juli">Juli</option>
                    <option value="Agustus">Agustus</option>
                    <option value="September">September</option>
                    <option value="Oktober">Oktober</option>
                    <option value="November">November</option>
                    <option value="Desember">Desember</option>
                  </select>
                  <svg>
                    <use xlink:href="#select-arrow-down"></use>
                  </svg>
                </label>
                <button class="btn btn-primary" style="height: 40px;" type="submit" id="btn_search"><i class="fa-solid fa-magnifying-glass"></i></button>
                <!-- SVG Sprites-->
                <svg class="sprites">
                  <symbol id="select-arrow-down" viewbox="0 0 10 6">
                    <polyline points="1 1 5 5 9 1"></polyline>
                  </symbol>
                </svg>
                </form>
          </div>


            <table class="table align-middle mb-0 bg-white" id="table_kuota" style="text-align: center; margin-top: 80px;">
              <thead class="bg-light">
                  <th style="text-align:center;">Tanggal</th>
                  <th style="text-align:center;">Kuota</th>
                  <th style="text-align:center;">Actions</th>
              </thead>
              <tbody>
                 <?php foreach ($result as $row) : ?>
                    <tr>
                      <td>
                        <?php 
                          $date    = strtotime($row['tanggal']);
                          $tanggal = date('d-M-Y', $date);
                          echo '<span class="badge badge-success" style="font-size: 15px;">'.$tanggal.'</span>';
                        ?>
                      </td>
                      <td>
                        <span class="badge badge-danger rounded-circle" style="font-size:20px;"><?= $row['kuota']; ?></span>
                      </td>
                      <td>
                        <button type="button" class="btn btn-warning" data-mdb-toggle="modal" data-mdb-target="#exampleModal<?php echo $row['id']; ?>">
                        <i class="fa-solid fa-pen"></i>
                      </button>

                        <button type="button" class="btn btn-danger" data-mdb-toggle="modal" data-mdb-target="#deleteModal<?php echo $row['id']; ?>">
                        <i class="fa-solid fa-trash"></i>
                      </button>
                    </td>
                    </tr>

                  <div class="modal fade" id="exampleModal<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                      <div class="modal-content">
                        <form action="proccess/update.php" method="post">
                        <div class="modal-header">
                          <h5 class="modal-title" id="exampleModalLabel">Edit</h5>
                          <button type="button" class="btn-close" data-mdb-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                          <input type="hidden" name="kuota_id" id="kuota_id" value="<?php echo $row['id']; ?>">
                          <div class="input-group mb-3">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-circle-info"></i></span>
                            <input
                              name="kuota" id="kuota"
                              type="text" value="<?php echo $row['kuota']; ?>"
                              class="form-control"
                              placeholder="kuota"
                              aria-label="kuota"
                              aria-describedby="basic-addon1"
                            />
                          </div>
                          <div class="input-group mb-3">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-calendar-days"></i></span>
                            <input
                              name="tanggal" id="tanggal"
                              type="date" value="<?php echo $row['tanggal']; ?>"
                              class="form-control"
                              placeholder="tanggal"
                              aria-label="tanggal"
                              aria-describedby="basic-addon1"
                            />
                          </div>
                        </div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-secondary" data-mdb-dismiss="modal">Close</button>
                          <button type="submit" name="btn_update" class="btn btn-primary">Save changes</button>
                        </div>
                      </form>
                      </div>
                    </div>
                  </div>


                  <div class="modal fade" id="deleteModal<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                      <div class="modal-content">
                        <form action="proccess/delete.php" method="post">
                        <div class="modal-header">
                          <h5 class="modal-title" id="exampleModalLabel">Hapus</h5>
                          <button type="button" class="btn-close" data-mdb-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                          <input type="hidden" name="kuota_id" id="kuota_id" value="<?php echo $row['id']; ?>">
                          <div class="input-group mb-3">
                            <p id="basic-addon1"><i class="fa-solid fa-circle-info"></i> &nbsp;Menghapus akan membuat kuota pada tanggal <?php echo $row['tanggal']; ?> tidak memiliki batas kuota</p>
                          </div>
                        </div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-secondary" data-mdb-dismiss="modal">Batal</button>
                          <button type="submit" name="btn_delete" class="btn btn-danger">Hapus</button>
                        </div>
                      </form>
                      </div>
                    </div>
                  </div>

                <?php endforeach; ?>
              </tbody>
            </table>



          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer mt-auto py-4">
    <div class="container">
      <hr class="my-4">
      <!-- copyright -->
      <div class="copyright text-center mb-2 mb-md-0">
        &copy; 2022 - <a href="https://antrian.casie.cloud/" target="_blank" class="text-danger text-decoration-none">antrian</a>. All rights reserved.
      </div>
    </div>
  </footer>

  <!-- jQuery Core -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
  <script src="assets/js/mdb.min.js"></script>

  <script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap4.min.js"></script>
  <!-- DataTables JS library -->
</body>
<script type="text/javascript">
      var getUrlParameter = function getUrlParameter(sParam) {
        var sPageURL = window.location.search.substring(1),
            sURLVariables = sPageURL.split('&'),
            sParameterName,
            i;

        for (i = 0; i < sURLVariables.length; i++) {
            sParameterName = sURLVariables[i].split('=');

            if (sParameterName[0] === sParam) {
                return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
            }
        }
        return false;
    };

    var month = getUrlParameter('month');
    if (month) {
      const $select = document.querySelector('#month');
      $select.value = month
    }

    $(document).ready(function() {
      $('#table_kuota').DataTable({
    order: [[0, 'desc']],
    });
  } );
</script>
</html>