<?php
session_start();
//mengecek username pada session
if( !isset($_SESSION['email']) ){
  $_SESSION['msg'] = 'anda harus login untuk mengakses halaman ini';
  header('Location: index.php');
}


include_once 'connection/connect.php';
  $tanggal = date('Y-m-d');
  $result = $mysqli->query("
     SELECT id, nomor, waktu, status FROM antrian WHERE DATE(waktu)='$tanggal' AND is_close=false ORDER BY id ASC
  ");

  $data_antrian = mysqli_query($mysqli, "
     SELECT (SELECT COUNT(id) AS total_antrian FROM antrian where DATE(waktu)='$tanggal') AS total_antrian,(SELECT COUNT(id) AS total_menunggu FROM antrian where DATE(waktu)='$tanggal' AND status='menunggu') AS total_menunggu,(SELECT COUNT(id) AS total_selesai FROM antrian where DATE(waktu)='$tanggal' AND status='selesai') AS total_selesai");
 
  $data_kuota = mysqli_query($mysqli, "
   SELECT kuota FROM kuota WHERE DATE(tanggal)='$tanggal'");

  if (mysqli_num_rows($data_kuota) == 0) {
    $total_kuota = "~";
  } else {
    foreach ($data_kuota as $key => $value) {
      $total_kuota = $value['kuota'];
    }
  }

  foreach ($data_antrian as $key => $value) {
    $total_antrian  = $value['total_antrian'] ?? 0;
    $total_menunggu = $value['total_menunggu'] ?? 0;
    $total_selesai  = $value['total_selesai'] ?? 0;
  }
?>
<!doctype html>
<html lang="en" class="h-100">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="author" content="boons">

  <!-- Title -->
  <title>Aplikasi Antrian</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-+0n0xVW2eSR5OomGNYDnhzAbDsOXxcvSN1TPprVMTNDbiYZCxYbOOl7+AMvyTG2x" crossorigin="anonymous">

  <!-- Font -->
<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"
  rel="stylesheet"
/>
  <!-- Custom Style -->
  <link rel="stylesheet" href="assets/css/mdb.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
</head>

<body class="d-flex flex-column h-100 bd_body">
  <main class="flex-shrink-0">
    <div class="container pt-4">


<!-- Navbar -->
<nav class="navbar navbar-collapse navbar-expand-lg navbar-light bg-light" style="border-radius: 20px !important;">
  <!-- Container wrapper -->
  <div class="container-fluid">
    <!-- Toggle button -->
    <button
      class="navbar-toggler"
      type="button"
      data-mdb-toggle="collapse"
      data-mdb-target="#navbarSupportedContent"
      aria-controls="navbarSupportedContent"
      aria-expanded="false"
      aria-label="Toggle navigation"
    >
      <i class="fas fa-bars"></i>
    </button>

    <!-- Collapsible wrapper -->
    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <!-- Navbar brand -->
      <a class="navbar-brand mt-2 mt-lg-0" href="#">
        <i class="fa-solid fa-bell text-danger" style="font-size: 40px;"></i>
      </a>
      <!-- Left links -->
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link" href="index.php">Dashboard Antrian</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="kuota.php">Kuota</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="logs.php">Logs</a>
        </li>
      </ul>
      <!-- Left links -->
    </div>
    <!-- Collapsible wrapper -->

    <!-- Right elements -->
    <div class="d-flex align-items-center">
      <!-- Avatar -->
      <div class="dropdown">
        <a
          class="dropdown-toggle d-flex align-items-center hidden-arrow"
          href="#"
          id="navbarDropdownMenuAvatar"
          role="button"
          data-mdb-toggle="dropdown"
          aria-expanded="false"
        >
        Admin  &nbsp;&nbsp;<i class="fa-solid fa-caret-down"></i>
        </a>
        <ul
          class="dropdown-menu dropdown-menu-end"
          aria-labelledby="navbarDropdownMenuAvatar"
        >
          <li>
            <a class="dropdown-item" href="logout.php">Logout</a>
          </li>
        </ul>
      </div>
    </div>
    <!-- Right elements -->
  </div>
  <!-- Container wrapper -->
</nav>
<!-- Navbar -->



  <div id="connecting" style="margin: 20px;">Connecting to web sockets server...</div>
      <div class="row" style="margin-top: 20px;">
        <!-- menampilkan kuota jumlah antrian -->
        <div class="col-md-3 mb-4">
          <div class="card border-0 shadow-sm">
            <div class="card-body p-4">
              <div class="d-flex justify-content-start">
                <div class="feature-icon-3 me-4 size_icon">
                  <i class="fa-solid fa-circle-exclamation text-info"></i>
                </div>
                <div>
                    <span id="jumlah_kuota" class="fs-3 text-info mb-1"><?php echo $total_kuota;?></span>
                    <p class="mb-0 text-info" style="font-size: 15px;">Kuota Antrian</p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- menampilkan informasi jumlah antrian -->
        <div class="col-md-3 mb-4">
          <div class="card border-0 shadow-sm">
            <div class="card-body p-4">
              <div class="d-flex justify-content-start">
                <div class="feature-icon-3 me-4 size_icon">
                  <i class="fa-solid fa-user-group text-warning"></i>
                </div>
                <div>
                    <span id="jumlah_antrian" class="fs-3 text-warning mb-1"><?php echo $total_antrian;?></span>
                    <p class="mb-0 text-warning" style="font-size: 15px;">Total Antrian</p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- menampilkan informasi nomor antrian yang sedang dipanggil -->
        <div class="col-md-3 mb-4">
          <div class="card border-0 shadow-sm">
            <div class="card-body p-4">
              <div class="d-flex justify-content-start">
                <div class="feature-icon-3 me-4 size_icon">
                  <i class="fa-solid fa-user-clock text-danger"></i>
                </div>
                <div>
                    <span id="antrian_menunggu" class="fs-3 text-danger mb-1"><?php echo $total_menunggu;?></span>
                    <p class="mb-0 text-danger" style="font-size: 15px;">Antrian Menunggu</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- menampilkan informasi jumlah antrian yang belum dipanggil -->
        <div class="col-md-3 mb-4">
          <div class="card border-0 shadow-sm">
            <div class="card-body p-4">
              <div class="d-flex justify-content-start">
                <div class="feature-icon-3 me-4 size_icon">
                  <i class="fa-solid fa-user-check text-success"></i>
                </div>
                <div>
                    <span id="antrian_selesai" class="fs-3 text-success mb-1"><?php echo $total_selesai;?></span>
                    <p class="mb-0 text-success" style="font-size: 15px;">Antrian Selesai</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="card border-0 shadow-sm">
        <div class="card-body p-4">
          <div class="table-responsive">



<table class="table align-middle mb-0 bg-white" id="tabel-antrian" style="text-align: center;">
  <thead class="bg-light">
      <th>Nomor Antrian</th>
      <th>Waktu</th>
      <th>Status</th>
      <th>Actions</th>
  </thead>
  <tbody>
     <?php foreach ($result as $row) : ?>
        <tr id="item_<?php echo $row['id'];?>">
          <td>
            <?php
              $statu = $row['status'];
              $nomor = $row['nomor'];
              if ($statu == "menunggu") {
                echo '<span class="badge badge-danger rounded-circle" style="font-size:20px;">'.$nomor.'</span>';
              }else{
                echo '<span class="badge badge-success rounded-circle" style="font-size:20px;">'.$nomor.'</span>';
              }
            ?>
          </td>
          <td>
            <?php 
              $date    = strtotime($row['waktu']);
              $tanggal = date('d-M-Y', $date);
              $waktu   = date('H:i', $date);
              echo '<span class="badge badge-light rounded-pill">'.$tanggal.'</span>&nbsp;';
              echo '&nbsp;<span class="badge badge-primary rounded-pill">'.$waktu.'</span>';
            ?>
          <td>
          <?php
            if ($statu == "menunggu") {
              echo '<span class="badge badge-warning rounded-pill d-inline" style="font-size:15px;">'.$statu.'</span>';
            }else{
              echo '<span class="badge badge-success rounded-pill d-inline" style="font-size:15px;">'.$statu.'</span>';
            }
          ?>
          </td>
          <td>
          <?php if ($row['status'] == 'menunggu') { ?>
             <button class="btn btn-danger btn-sm detail btn-rounded" data-id="<?php echo $row['id'] ?>" data-nomor="<?php echo $row['nomor'] ?>"><i class="fa-solid fa-volume-high"></i> Panggil</button>
         <?php  }else{ ?>
            <button class="btn btn-success btn-sm detail btn-rounded" data-id="<?php echo $row['id'] ?>" data-nomor="<?php echo $row['nomor'] ?>"><i class="fa-solid fa-repeat"></i> Ulang</button>
          <?php } ?>
        </td>
        </tr>
    <?php endforeach; ?>
  </tbody>
</table>

          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer mt-auto py-4">
    <div class="container">
      <hr class="my-4">
      <!-- copyright -->
      <div class="copyright text-center mb-2 mb-md-0">
        &copy; 2022 - <a href="https://antrian.casie.cloud/" target="_blank" class="text-danger text-decoration-none">antrian</a>. All rights reserved.
      </div>
    </div>
  </footer>

  <!-- load file audio bell antrian -->
  <audio id="tingtung" src="assets/audio/tingtung.mp3"></audio>

  <!-- jQuery Core -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
  <script src="assets/js/mdb.min.js"></script>

  <!-- Responsivevoice -->
  <!-- Get API Key -> https://responsivevoice.org/ -->
  <script src="https://code.responsivevoice.org/responsivevoice.js?key=jQZ2zcdq"></script>
</body>
<script type="text/javascript" src="js-index.js"></script>
<script type="text/javascript">
        // panggilan antrian dan update data
    $(document).on("click",".detail",function() {

        var id = $(this).data("id");
        var nomor = $(this).data("nomor");
        var bell = document.getElementById('tingtung');

        // mainkan suara bell antrian
        bell.pause();
        bell.currentTime = 0;
        bell.play();

        // set delay antara suara bell dengan suara nomor antrian
        durasi_bell = bell.duration * 770;

        // mainkan suara nomor antrian
        setTimeout(function() {
          responsiveVoice.speak("Nomor Antrian, " + nomor + ", menuju, loket, 1", "Indonesian Male", {
            rate: 0.9,
            pitch: 1,
            volume: 1
          });
        }, durasi_bell);
        var index_row = $("#item_"+id+"").index();
        console.log(index_row);
        // proses update data
        $.ajax({
          type: "POST",               // mengirim data dengan method POST
          url: "update.php",          // url file proses update data
          data: { id: id, index_row: index_row}            // tentukan data yang dikirim
        });
    });





</script>
</html>